/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.save;

import com.direwolf20.buildinggadgets.common.tainted.save.TimedDataSave;
import com.direwolf20.buildinggadgets.common.tainted.template.Template;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public final class TemplateSave
extends TimedDataSave<TemplateInfo> {
    public static TemplateSave loads(CompoundTag tag) {
        TemplateSave templateSave = new TemplateSave();
        templateSave.load(tag);
        return templateSave;
    }

    public Template getTemplate(UUID id) {
        TemplateInfo info = this.get(id, uuid -> new TemplateInfo());
        return this.markDirtyAndUpdate(info).getTemplate();
    }

    void setTemplate(UUID id, Template template) {
        this.markDirtyAndUpdate(this.get(id, uuid -> new TemplateInfo(template))).setTemplate(template);
    }

    void removeTemplate(UUID id) {
        this.remove(id);
        this.m_77762_();
    }

    @Override
    protected TemplateInfo createValue() {
        return new TemplateInfo();
    }

    @Override
    protected TemplateInfo readValue(CompoundTag nbt) {
        return new TemplateInfo(nbt);
    }

    private TemplateInfo markDirtyAndUpdate(TemplateInfo info) {
        this.m_77762_();
        return info.updateTime();
    }

    static final class TemplateInfo
    extends TimedDataSave.TimedValue {
        private Template template;

        private TemplateInfo(CompoundTag nbt) {
            super(nbt);
            this.template = Template.deserialize(nbt.m_128469_("data"), null, true);
        }

        private TemplateInfo(Template template) {
            this.template = template;
        }

        private TemplateInfo(long lastUpdateTime, Template template) {
            super(lastUpdateTime);
            this.template = template;
        }

        private TemplateInfo() {
            this(new Template());
        }

        private Template getTemplate() {
            return this.template;
        }

        public TemplateInfo setTemplate(Template template) {
            this.template = template;
            return this;
        }

        @Override
        public TemplateInfo updateTime() {
            return (TemplateInfo)super.updateTime();
        }

        @Override
        public CompoundTag write() {
            CompoundTag nbt = super.write();
            nbt.m_128365_("data", (Tag)this.template.serialize(true));
            return nbt;
        }
    }
}

